clear all;
close all;
% vector version

%[l,a,lambda,jcr,sigma]
par0 = [0.02   1.71   .15   0.055   1];

%[R,T,S,v,theta]
R0 = [ -.56 ; -.74 ; -.92 ];
T0 = [ -.41 ; -.43 ; -.44 ];
S0 = [ -.33 ; -.33 ; -.33 ];
v0 = [ .059 ; .092 ; .116 ];
theta0 = [ .26 ; .47 ; .68 ];

var0 = [R0,T0,S0,v0,theta0];

%[c,beta,r,b,k,nu]
otherpar0 = [0.465  0.5     0.01    0.8     0.1     1];

%[xsi,alpha]
parmatch0 = [0.6    0.5];

global TRMAT P;
chi1 = .022;
phi = .9165;
psi = .01675;
gamma = 0.067;
t13 = 1-phi-gamma;
t22 = 1-2*psi;


TRMAT = [ phi    gamma     t13 ;   psi     t22      psi ;   t13     gamma     phi  ]   ;
P = [exp(chi1) ; 1 ; exp(-chi1) ] ;

%%%%%%%%%%%%%%%%%%%%%%%%%%
% calibration adjustment to match u rate (and u flows)
%P = .9*P
%par0(3)=par0(3)*1
%%%%%%%%%%%%%%%%%%%%%%%%%%

[l0,a0,lambda0,jcr0,sigma0] = expandpar(par0);
[c0,beta0,r0,b0,k0,nu0] = expandotherpar(otherpar0);

SIG0 = sigma0 * ones(3,1);

A1(par0,otherpar0,parmatch0,var0);
A2(par0,otherpar0,parmatch0,var0);
A3(par0,otherpar0,parmatch0,var0);

SurplbelowT(R0,par0,otherpar0,parmatch0,var0);
Vo(T0,par0,otherpar0,parmatch0,var0);
Surplo(S0,par0,otherpar0,parmatch0,var0) - Surpln(S0,par0,otherpar0,parmatch0,var0);

var1 = fivecds(par0,otherpar0,parmatch0,var0);
[R1,T1,S1,v1,theta1]=expandvar(var1);

[ SurplbelowT(R1,par0,otherpar0,parmatch0,var1) ...
Vo(T1,par0,otherpar0,parmatch0,var1) ...
Surplo(S1,par0,otherpar0,parmatch0,var1) - Surpln(S1,par0,otherpar0,parmatch0,var1) ]

%model outcomes
% u     v     v/u   theta  u/j  exitrate inflrate  meanw
vu=var1(:,4)./u(par0,var1,parmatch0);
uoj=u(par0,var1,parmatch0)./ojres(par0,var1,parmatch0);
exitrate = theta1.*q(theta1,parmatch0);
inrate = lambda0*Fcdf(R1,par0)+l0;
meanw = iwFE(par0,otherpar0,parmatch0,var1);

res=[u(par0,var1,parmatch0) v1 vu theta1 uoj exitrate inrate meanw]

%relative volatilities of model outcomes
relvol=zeros(2,8);

for i=1:8;
    relvol(1,i)=log(res(1,i)/res(2,i))/log(P(1)/P(2));
    relvol(2,i)=log(res(2,i)/res(3,i))/log(P(2)/P(3));
 end;
 relvol
 
%flows
JF=lambda0*Fcdf(R1,par0).*(1-u(par0,var1,parmatch0));
JJF=a0*theta1.*q(theta1,parmatch0).*ojres(par0,var1,parmatch0);
UF=exitrate.*u(par0,var1,parmatch0);
LF=l0*(1-u(par0,var1,parmatch0));
WF=UF+JJF;
JFWF=JF./WF;
UFJF=UF./JF;

flows = [JF JJF UF LF WF JFWF UFJF]

%relative volatilities of w and j flows
flvol=zeros(1,7);

for i=1:7;
    flvol(1,i)=log(flows(1,i)/flows(2,i))/log(P(1)/P(2));
    flvol(2,i)=log(flows(2,i)/flows(3,i))/log(P(2)/P(3));
 end;
 flvol

%fraction of job movers experiencing wage drops

frac = (FES(par0,var1,parmatch0)-FET(par0,var1,parmatch0)) .* FVTS(S1,par0,var1,parmatch0) ./ FES(par0,var1,parmatch0) /2
     
 
 
%Surplo(T1,par0,otherpar0,parmatch0,var1)
%SoT(par0,otherpar0,parmatch0,var1)


%imag(var1)
%var1 = real(var1);
%[R,T,S,v,theta]=expandvar(var1)
